package gov.va.med.mhv.sm.admin.web.util;

import gov.va.med.mhv.sm.admin.web.exception.SMSummaryOnlyMessage;

import java.util.List;

import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.RequestScoped;
import javax.faces.context.FacesContext;

@ManagedBean(name="messageUtil")
@RequestScoped
public class MessageUtil {

	public static final String NO_WRAPPER = "NO_WRAPPER";

	public boolean getSummaryMessagesViewRequested() {
		boolean result = false;
		List<FacesMessage> messageList = FacesContext.getCurrentInstance().getMessageList();
		if (messageList != null) {
			for (FacesMessage m : messageList) {
				if (m instanceof SMSummaryOnlyMessage || NO_WRAPPER.equals(m.getDetail())) {
					result = true;
				}
			}
		}
		return result;
	}
}
